/**
 *                      ///\\\      \\\
 *                     ///  \\\     \\\
 *                    ///           \\\
 *                   ///            \\\\\\\\\\\\
 *                   \\\            \\\      \\\
 *                    \\\           \\\      \\\
 *                     \\\  ///     \\\      \\\
 *                      \\\///      \\\\\\\\\\\\
 */




/**
 * The important ID`s & CLASS`es which i use to handle apps functionalities:
 * 1.(To handle side menu) mocBtn{i} => minMaxMenuWrr{i}, minMenu{i}, maxMenu{i}.
 * 2.(To handle info) octBtn{i} => octDataWrr{i}.
 * 3.(To handle Apps tabs) chatTabBtn{i}, contactTabBtn{i}, archiveTabBtn{i} => chatTab{i}, contactTab{i}, archiveTab{i}.
 * 4.(To handle apps popup) popupBtn{c} => popupMenuPad{c}, newDataNumVisulizer{c}.
 * 5.(To handle search) SearchInputBox{i} => maxUserRowContainer{i}, append-able-user-row{c}, search-able-data{c}.
 * 6.(To handle chat box container) append-able-user-row{c} => startUpWindow{i}, multipleChatWindow{i}, singleChatWindow{i}
 * 7.(To handle add new contact window) addNewContactOpenBtn{i}, addNewContactPadQuitBtn{i} => addNewContactPad{i}.
 */

class App {
    constructor() {}

    /**
     This is the App current state object.
     Here MFUR = Map For UserId Researvation.
     And appendedUserIds is a set which keep remined appended user ids to stop propagation.
    **/
    static state = {
        isOpenedCallWindow: null,
        appendedUserIds: new Set(),
        MFUR: new Map()
    };

    /**
     This is the icons object which contains apps icon.
     If you want, you can change the svg code of the icon and also add more icons here.
    **/
    static icons = {
        xmark: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;height: 20px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 0 1024 1024" version="1.1"><path d="M512.896 466.730667L816.298667 174.933333a38.698667 38.698667 0 0 1 8.192-5.717333 32.256 32.256 0 0 1 29.056 0.554667 35.84 35.84 0 0 1 10.197333 8.576 32 32 0 0 1-3.072 42.709333L557.226667 512.853333l291.797333 303.445334c1.962667 2.218667 2.56 2.730667 4.138667 5.248a32.341333 32.341333 0 0 1 2.474666 28.970666 32 32 0 0 1-50.304 12.416c-0.853333-0.725333-1.621333-1.536-2.432-2.304l-291.797333-303.402666-303.402667 291.797333c-2.261333 1.962667-2.773333 2.517333-5.290666 4.096a32.085333 32.085333 0 0 1-28.970667 2.474667 32.298667 32.298667 0 0 1-18.688-38.528c1.237333-4.266667 3.413333-8.32 6.272-11.733334 0.725333-0.853333 1.536-1.621333 2.304-2.432l303.402667-291.797333L174.933333 207.658667c-1.92-2.218667-2.517333-2.730667-4.096-5.248a32.341333 32.341333 0 0 1-2.474666-28.970667 32.298667 32.298667 0 0 1 38.528-18.688 31.573333 31.573333 0 0 1 11.733333 6.272c0.853333 0.725333 1.621333 1.536 2.432 2.304l291.84 303.402667z"></path></svg>`,
        menu: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 24px;height: 24px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M120-240v-66.67h720V-240H120Zm0-206.67v-66.66h720v66.66H120Zm0-206.66V-720h720v66.67H120Z"></path></svg>`,
        info: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 24px;height: 24px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M440-280h80v-240h-80v240Zm40-320q17 0 28.5-11.5T520-640q0-17-11.5-28.5T480-680q-17 0-28.5 11.5T440-640q0 17 11.5 28.5T480-600Zm0 520q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path></svg>`,
        phone: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;height: 20px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M798-120q-125 0-247-54.5T329-329Q229-429 174.5-551T120-798q0-18 12-30t30-12h162q14 0 25 9.5t13 22.5l26 140q2 16-1 27t-11 19l-97 98q20 37 47.5 71.5T387-386q31 31 65 57.5t72 48.5l94-94q9-9 23.5-13.5T670-390l138 28q14 4 23 14.5t9 23.5v162q0 18-12 30t-30 12ZM241-600l66-66-17-94h-89q5 41 14 81t26 79Zm358 358q39 17 79.5 27t81.5 13v-88l-94-19-67 67ZM241-600Zm358 358Z"/></svg>`,
        fullScreen: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 18px; height: 18px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M120-120v-200h80v120h120v80H120Zm520 0v-80h120v-120h80v200H640ZM120-640v-200h200v80H200v120h-80Zm640 0v-120H640v-80h200v200h-80Z"></path></svg>`,
        fullScreenExit: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 24px; height: 24px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M240-120v-120H120v-80h200v200h-80Zm400 0v-200h200v80H720v120h-80ZM120-640v-80h120v-120h80v200H120Zm520 0v-200h80v120h120v80H640Z"/></svg>`,
        pinp: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;height: 20px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M400-280h360v-240H400v240ZM160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Zm0-80h640v-480H160v480Zm0 0v-480 480Z"/></svg>`,
        btot: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;height: 20px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h280v80H200v560h560v-280h80v280q0 33-23.5 56.5T760-120H200Zm188-212-56-56 372-372H560v-80h280v280h-80v-144L388-332Z"></path></svg>`,
        arrow: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 25px; height: 25px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M480-528 296-344l-56-56 240-240 240 240-56 56-184-184Z"/></svg>`,
        attachFile: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 25px; height: 25px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M720-330q0 104-73 177T470-80q-104 0-177-73t-73-177v-370q0-75 52.5-127.5T400-880q75 0 127.5 52.5T580-700v350q0 46-32 78t-78 32q-46 0-78-32t-32-78v-370h80v370q0 13 8.5 21.5T470-320q13 0 21.5-8.5T500-350v-350q-1-42-29.5-71T400-800q-42 0-71 29t-29 71v370q-1 71 49 120.5T470-160q70 0 119-49.5T640-330v-390h80v390Z"/></svg>`,
        audio: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 25px; height: 25px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M480-400q-50 0-85-35t-35-85v-240q0-50 35-85t85-35q50 0 85 35t35 85v240q0 50-35 85t-85 35Zm0-240Zm-40 520v-123q-104-14-172-93t-68-184h80q0 83 58.5 141.5T480-320q83 0 141.5-58.5T680-520h80q0 105-68 184t-172 93v123h-80Zm40-360q17 0 28.5-11.5T520-520v-240q0-17-11.5-28.5T480-800q-17 0-28.5 11.5T440-760v240q0 17 11.5 28.5T480-480Z"/></svg>`,
        emoji: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 25px; height: 25px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M620-520q25 0 42.5-17.5T680-580q0-25-17.5-42.5T620-640q-25 0-42.5 17.5T560-580q0 25 17.5 42.5T620-520Zm-280 0q25 0 42.5-17.5T400-580q0-25-17.5-42.5T340-640q-25 0-42.5 17.5T280-580q0 25 17.5 42.5T340-520Zm140 260q68 0 123.5-38.5T684-400H276q25 63 80.5 101.5T480-260Zm0 180q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-400Zm0 320q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Z"/></svg>`,
        love: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 25px; height: 25px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="m480-120-58-52q-101-91-167-157T150-447.5Q111-500 95.5-544T80-634q0-94 63-157t157-63q52 0 99 22t81 62q34-40 81-62t99-22q94 0 157 63t63 157q0 46-15.5 90T810-447.5Q771-395 705-329T538-172l-58 52Zm0-108q96-86 158-147.5t98-107q36-45.5 50-81t14-70.5q0-60-40-100t-100-40q-47 0-87 26.5T518-680h-76q-15-41-55-67.5T300-774q-60 0-100 40t-40 100q0 35 14 70.5t50 81q36 45.5 98 107T480-228Zm0-273Z"/></svg>`,
        send: `<svg xmlns="http://www.w3.org/2000/svg" style="width: 30px;height: 30px;vertical-align: middle;fill: currentColor;overflow: hidden;" viewBox="0 -960 960 960"><path d="M120-160v-640l760 320-760 320Zm80-120 474-200-474-200v140l240 60-240 60v140Zm0 0v-400 400Z"></path></svg>`
    };

    /**
     This is the emojis object which contains apps emojis.
     If you want, you can change the array as you wish and also add more emojis here.
    **/
    static emojis = ['😴', '🥱', '😫', '😪', '😯', '🤐', '😮', '😥', '😣', '😏', '🙄', '😶‍🌫️', '🫥', '😶', '😑', '😐', '🤨', '🫡', '🤔', '🤩', '🤗', '🙂', '😚', '💖', '💗', '💓'];

    /**
     GEBI = Get Element By Id.
     This static method is used for select a DOM ID.
    **/
    static GEBI(name, root=document) {
        return root.getElementById(name);
    }

    /**
     GEBC = Get Element By Class.
     This static method is used for select a DOM Class.
     It returns a array of the class elements.
    **/
    static GEBC(name, root=document) {
        return root.getElementsByClassName(name);
    }

    /**
     CE = Create Element.
     This static method is used for creating a new Dom element.
    **/
    static CE(name, root=document) {
        return root.createElement(name);
    }

    /**
     This static method is for generate a random ID.
     The default length of the id is `21`. If you want a different length just put the number in you method.
    **/
    static generateRandomId(length = 21) {
        const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";
        let randomId = "";
        for (let i = 0; i < length; i++) {
            randomId += characters.charAt(Math.floor(Math.random() * characters.length));
        }
        return randomId;
    }

    /**
     This static method handle the side menu.
     Here the maximize side menu width = 320px & the minimize side menu width = 90px.
     If you want to change them just change maxWidth & minWidth variables.
    **/
    static handleSideMenu() {
        var maxWidth = '400px';
        var minWidth = '90px';
        var menuBtn = App.GEBI('mocBtn');
        var menuWrr = App.GEBI('minMaxMenuWrr');
        var minMenu = App.GEBI('minMenu');
        var maxMenu = App.GEBI('maxMenu');

        // set default configuration...
        menuWrr.style['min-width'] = minWidth;
        menuWrr.style['max-width'] = minWidth;
        minMenu.style['display'] = 'block';
        maxMenu.style['display'] = 'none';
        menuBtn.innerHTML = App.icons.menu;

        // function to handle onclick event...
        menuBtn.onclick = function () {
            if (menuWrr.style['min-width'] === maxWidth) {
                menuBtn.innerHTML = App.icons.menu;
                menuWrr.style['min-width'] = minWidth;
                menuWrr.style['max-width'] = minWidth;
                minMenu.style['display'] = 'block';
                maxMenu.style['display'] = 'none';
            } else {
                menuBtn.innerHTML = App.icons.xmark;
                menuWrr.style['min-width'] = maxWidth;
                menuWrr.style['max-width'] = maxWidth;
                minMenu.style['display'] = 'none';
                maxMenu.style['display'] = 'block';
            }
        }
    }

    /**
     This static method handle info component.
    **/
    static handleOCT() {
        var octBtn = App.GEBI('octBtn');
        var octDataWrr = App.GEBI('octDataWrr');

        // set default configuration...
        octDataWrr.style['display'] = 'none';
        octBtn.innerHTML = App.icons.info;

        // function to handle onclick event...
        octBtn.onclick = function () {
            if (octDataWrr.style['display'] === 'block') {
                    octDataWrr.style['display'] = 'none';
                    octBtn.innerHTML = App.icons.info;
            } else {
                    octBtn.innerHTML = App.icons.xmark;
                    octDataWrr.style['display'] = 'block';
            }
        }
    }

    /**
     This static method handle app`s tab system.
    **/
    static handleTab() {
        const tabObject = {
            tabBtns: [App.GEBI('chatTabBtn'), App.GEBI('contactTabBtn')],
            tabPads: [App.GEBI('chatTab'), App.GEBI('contactTab')]
        }

        for (let i = 0; i < tabObject.tabBtns.length; i++) {
            const tabBtn = tabObject.tabBtns[i];
            tabBtn.onclick = function () {
                for (let j = 0; j < tabObject.tabPads.length; j++) {
                    tabObject.tabBtns[j].classList.remove('active');
                    tabObject.tabPads[j].style.display = 'none';
                }
                tabObject.tabPads[i].style.display = 'flex';
                this.classList.add('active');
            }
        }

        App.GEBI('archiveTabBtnInpc').onclick = function (event) {
            const appendedChatBoxes = App.GEBC('appended-chat-box');
            const archiveChatBoxes = App.GEBC('archive-chat-row');

            if (this.checked) {
                App.GEBI('gen-chat-rows-wrapper').style.display = 'none';
                App.GEBI('arc-chat-rows-wrapper').style.display = 'flex';
                
                for (let i = 0; i < appendedChatBoxes.length; i++) {
                    appendedChatBoxes[i].style.display = 'none';
                }
                for (let i = 0; i < archiveChatBoxes.length; i++) {
                    archiveChatBoxes[i].style.display = 'flex';
                }

                if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                    // To open start-up window...
                    App.GEBI('startUpWindow').style['display'] = 'flex';
                    App.GEBI('multipleChatWindow').style['display'] = 'none';
                    App.GEBI('singleChatWindow').style['display'] = 'none';
                } else {
                    // To open multiple chat window...
                    App.GEBI('startUpWindow').style['display'] = 'none';
                    App.GEBI('multipleChatWindow').style['display'] = 'flex';
                    App.GEBI('singleChatWindow').style['display'] = 'none';
                }

                if (App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                    App.GEBI('pinpChatWindow').style['display'] = 'none';
                } else {
                    App.GEBI('pinpChatWindow').style['display'] = 'flex';
                }

            } else {
                App.GEBI('gen-chat-rows-wrapper').style.display = 'flex';
                App.GEBI('arc-chat-rows-wrapper').style.display = 'none';

                for (let i = 0; i < appendedChatBoxes.length; i++) {
                    appendedChatBoxes[i].style.display = 'flex';
                }

                for (let i = 0; i < archiveChatBoxes.length; i++) {
                    archiveChatBoxes[i].style.display = 'none';
                }

                if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                    // To open start-up window...
                    App.GEBI('startUpWindow').style['display'] = 'flex';
                    App.GEBI('multipleChatWindow').style['display'] = 'none';
                    App.GEBI('singleChatWindow').style['display'] = 'none';
                } else {
                    // To open multiple chat window...
                    App.GEBI('startUpWindow').style['display'] = 'none';
                    App.GEBI('multipleChatWindow').style['display'] = 'flex';
                    App.GEBI('singleChatWindow').style['display'] = 'none';
                }

                if (App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                    App.GEBI('pinpChatWindow').style['display'] = 'none';
                } else {
                    App.GEBI('pinpChatWindow').style['display'] = 'flex';
                }
            }
        }
    }

    /**
     This static method handle app`s pop-up system.
    **/
    static handlePopUp() {
        setInterval(() => {
            var btn = App.GEBC('popupBtn'),
            pop_up = App.GEBC('popupMenuPad');
            for (var i = 0; i < btn.length; i++) {
                btn[i].onclick = function (event) {
                    event.stopPropagation();
                    let cn = this.parentNode.parentNode.getElementsByClassName('popupMenuPad')[0];

                    if (cn.style.display=='flex') {
                        cn.style.display='none';
                        if (this.closest('.right-col') && this.closest('.user-row')) {

                            var rightCol = App.GEBC('right-col');
                            for (let i = 0; i < rightCol.length; i++) {
                                rightCol[i].style.opacity = '';
                            }
    
                            var userRow = App.GEBC('user-row');
                            for (let i = 0; i < userRow.length; i++) {
                                userRow[i].style.background = '';
                            }
                        }
                    } else {
                        for (var j = 0; j < pop_up.length; j++) {
                            pop_up[j].style.display='none';
                        }
                        cn.style.display='flex';

                        if (this.closest('.right-col') && this.closest('.user-row')) {

                            var rightCol = App.GEBC('right-col');
                            for (let i = 0; i < rightCol.length; i++) {
                                rightCol[i].style.opacity = '';
                            }
    
                            var userRow = App.GEBC('user-row');
                            for (let i = 0; i < userRow.length; i++) {
                                userRow[i].style.background = '';
                            }
    
                            this.closest('.right-col').style.opacity = '1';
                            this.closest('.user-row').style.background = '#cdd1d5';
                        }
                    }

                    let newDataNumVisulizer = App.GEBC('newDataNumVisulizer', this)[0];
                    if (newDataNumVisulizer) {
                        newDataNumVisulizer.style['display'] = 'none';
                        newDataNumVisulizer.innerHTML = '';
                    }


                }
            }
        }, 100);
    }

    /**
     This static method handle app`s text based search system.
    **/
    static handleSearchBytext() {
        const SearchInputBox = App.GEBI('SearchInputBox');
        const maxUserRowContainer =  App.GEBI('maxUserRowContainer');
        const userRow = App.GEBC('append-able-user-row', maxUserRowContainer);
        
        SearchInputBox.oninput = function () {
            if (this.value != '') {
        
                var sr_num = 0;
            
                for (let i = 0; i < userRow.length; i++) {
            
                    let node = App.GEBC('search-able-data', userRow[i])[0];
                    if (node) {
                        let nval = node.innerText.toUpperCase();
            
                        if (nval.includes(this.value.toUpperCase())) {
                            sr_num++;
                            userRow[i].parentNode.style.display='flex';
                        } else{
                            userRow[i].parentNode.style.display='none';
                        }
                    }
                }
                if (!sr_num) {
                    var divToRemove = App.GEBI('NotfoundUserBox');
                    if (!divToRemove) {
                        var userContentBox = App.CE('div');
                        userContentBox.setAttribute('class', 'found-0 w-100 flex ffc jcc aic p-20 g-10');
                        userContentBox.setAttribute('id', 'NotfoundUserBox');
                        userContentBox.innerHTML += `
                            <div class="flex">
                                    <img src="./img/search-no-result-not-found-260nw-2334577041.jpg" alt="">
                            </div>
                            <div class="">No user found!</div>
                        `;
            
                        maxUserRowContainer.appendChild(userContentBox);
                    }
                } else{
                    var divToRemove = App.GEBI('NotfoundUserBox');
                    if (divToRemove) {
                        divToRemove.remove();
                    }
                }
            } else {
                var divToRemove = App.GEBI('NotfoundUserBox');
                if (divToRemove) {
                    divToRemove.remove();
                }
        
                for (let j = 0; j < userRow.length; j++) {
                    if (userRow[j]) {
                        userRow[j].parentNode.style.display='flex';
                    }
                }
            }
        }
    }

    /**
     This static method handle to append chat box on the multipleChatWindow{i}.
    **/
    static openMultipleChatWindow(row, i) {
        if (row.hasAttribute('user-id')) {
            var userId = row.getAttribute('user-id');
            if (!App.state.appendedUserIds.has(userId)) {

                // To display just multipleChatWindow{i}...
                App.GEBI('startUpWindow').style['display'] = 'none';
                App.GEBI('multipleChatWindow').style['display'] = 'flex';
                App.GEBI('singleChatWindow').style['display'] = 'none';
      
                // To apend a new chat box on multiple chat window...
                var chatRowType = (row.hasAttribute('chat-row-type'))?(row.getAttribute('chat-row-type')):('genaral-chat-row');
                const RID = App.generateRandomId();
                const chatBox =  App.CE('div');
                chatBox.setAttribute('class', `${chatRowType} msg-index-box multiple-msg-box appended-chat-box`);
                chatBox.setAttribute('id', RID);
                chatBox.innerHTML = `
                <div class="HIDEN-DATA-BOX" style="display: none;">
                        <input type="hidden" name="multipleChatUserId${RID}" class="userIdContainerInputBox" id="multipleChatUserId${RID}" value=${userId}>
                    </div>
                <div class="msg-index-head p-1rem">
                    <div class="flex jcsb aic g-0_5rem">
                        <div class="left-col flex g-0_5rem aic">
                            <div class="user-img-box append-box-img flex jcc aic">
                                <img src="./img/camera-4921646_1280.jpg" alt="">
                                <div class="online-indicator"></div>
                            </div>
                            <div class="user-name-and-last-msg-container">
                                <div class="user-name-box">Mahadi Hasan</div>
                                <div class="msg-sent-time-stamp">4 hours ago</div>
                            </div>
                        </div>
                        <div class="flex jcc aic wh-100"> <input class="msg-search-inp" type="text" placeholder="Type to search"> </div>
                        <div class="flex aic g-0_5rem">
                            <div class="call-btn flex jcc aic cup" user-id="${userId}">${App.icons.phone}</div>
                            <div class="flex cup fullScreenBtn" chat-row-type="${chatRowType}" del-id="${RID}" user-id="${userId}">${App.icons.fullScreen}</div>
                            <div class="pinp-btn flex jcc aic cup" chat-row-type="${chatRowType}" user-id="${userId}">${App.icons.pinp}</div>
                            <div class="remove-btn chatBoxRemoveButton flex jcc aic cup" del-id="${RID}" user-id="${userId}" user-row-index="${i}">${App.icons.xmark}</div>
                            <!--<div class="arrow-btn OpenCloseBtn flex jcc aic cup" style="transform: rotate(180deg);">${App.icons.arrow}</div>-->
                        </div>
                    </div>
                </div>
                <div class="msg-index-body OpenCloseBody">
                    <div class="ofh flex ffc wh-100">
            
                        <div class="msg-view-boxes-wrr-row ofh">
                            <div class="msg-data-view-box p-1rem wh-100">

                                <div class="flex ffc g-1rem">
                                    <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                        <div class="flex ffc g-0_5rem w-100">
                                            <div class="img-text-wrapper">
                                                <span class="user-img-wrapper">
                                                    <img src="./img/camera-4921646_1280.jpg" alt="">
                                                    <span class="online-indicator"></span>
                                                </span>
                                                <span class="msg-data-wrapper">
                                                    Hi! Seth, How are you?
                                                </span>
                                            </div>
                                            <div class="msg-sent-time-stamp"><span class="dot"></span> 5 hours ago</div>
                                        </div>
                                    </div>

                                    <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                        <div class="flex ffc g-0_5rem w-100">
                                            <div class="img-text-wrapper">
                                                <span class="user-img-wrapper">
                                                    <img src="./img/camera-4921646_1280.jpg" alt="">
                                                    <span class="online-indicator"></span>
                                                </span>
                                                <span class="msg-data-wrapper">
                                                    I'm fine Josef. And you?
                                                </span>
                                            </div>
                                            <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                        </div>
                                    </div>

                                    <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                        <div class="flex ffc g-0_5rem w-100">
                                            <div class="img-text-wrapper">
                                                <span class="user-img-wrapper">
                                                    <img src="./img/camera-4921646_1280.jpg" alt="">
                                                    <span class="online-indicator"></span>
                                                </span>
                                                <span class="msg-data-wrapper">
                                                    I'm also fine! Seth, Where are you now? If you are at home now, then i say could you please go with me in my university?
                                                </span>
                                            </div>
                                            <div class="msg-sent-time-stamp"><span class="dot"></span>5 hours ago</div>
                                        </div>
                                    </div>

                                    <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                        <div class="flex ffc g-0_5rem w-100">
                                            <div class="img-text-wrapper">
                                                <span class="user-img-wrapper">
                                                    <img src="./img/camera-4921646_1280.jpg" alt="">
                                                    <span class="online-indicator"></span>
                                                </span>
                                                <span class="msg-data-wrapper">
                                                    Yes Josef I'm at home. And I'm ready to go with you. So when you will go?
                                                </span>
                                            </div>
                                            <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="msg-call-view-box"></div>
                            <div class="msg-audio-view-box"></div>
                            <div class="msg-file-view-box"></div>
                        </div>
            
                        <form action="#" method="post" enctype="multipart/form-data" autocomplete="off" aria-required="true">
                            <div class="msg-input-box-wrr flex g-0_5rem p-1rem">
                                <div class="msg-input-attace-file-box sml-box-grp flex jcc aic">
                                    ${App.icons.attachFile}
                                    <input type="file" name="attace-file" class="fileUploadBtn" id="__file__${RID}" parent-id="${RID}" multiple>
                                </div>
                                <div class="msg-input-text-box flex jcc aic">
                                    <input type="text" name="msg-input" class="chat-box-text-input-container" parent-id="${RID}" placeholder="Type to massage">
                                </div>
                                <!--<div class="msg-input-voice-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.audio}</div>-->
                                <div class="msg-input-emoji-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.generateEmojiPad()}</div>
                                <div class="msg-input-love-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.love}</div>
                                <div class="msg-input-send-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.send}</div>
                            </div>
                        </form>
                    </div>
                </div>
                `;
                App.GEBI('multipleChatWindow').prepend(chatBox);
            
                // To scroll the new chat box on the bottom...
                const RIDE = App.GEBI(RID);
                const msgDataViewBox = App.GEBC('msg-data-view-box',RIDE)[0];
                msgDataViewBox.scrollTop = msgDataViewBox.scrollHeight;

                // Now set the append user id on the `appendedUserIds` set. This is for justification if this row is able to append?...
                App.state.appendedUserIds.add(userId);
                App.state.MFUR.set(userId, RID);
            } else {
                if (App.GEBI('archiveTabBtnInpc').checked) {
                    if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                        // To open start-up window...
                        App.GEBI('startUpWindow').style['display'] = 'flex';
                        App.GEBI('multipleChatWindow').style['display'] = 'none';
                        App.GEBI('singleChatWindow').style['display'] = 'none';
                    } else {
                        // To open multiple chat window...
                        App.GEBI('startUpWindow').style['display'] = 'none';
                        App.GEBI('multipleChatWindow').style['display'] = 'flex';
                        App.GEBI('singleChatWindow').style['display'] = 'none';
                    }
                } else {
                    if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                        // To open start-up window...
                        App.GEBI('startUpWindow').style['display'] = 'flex';
                        App.GEBI('multipleChatWindow').style['display'] = 'none';
                        App.GEBI('singleChatWindow').style['display'] = 'none';
                    } else {
                        // To open multiple chat window...
                        App.GEBI('startUpWindow').style['display'] = 'none';
                        App.GEBI('multipleChatWindow').style['display'] = 'flex';
                        App.GEBI('singleChatWindow').style['display'] = 'none';
                    }
                }

                console.warn('This user id already append!');
            }

            // To none display `new-msg-num`
            const minMenuAAURs = App.GEBC('append-able-user-row', App.GEBI('minMenu'));
            for (let i = 0; i < minMenuAAURs.length; i++) {
                var minMenuAAUR = minMenuAAURs[i];
                if (minMenuAAUR.hasAttribute('user-id') && minMenuAAUR.getAttribute('user-id') === userId) {
                    App.GEBC('new-msg-num', minMenuAAUR)[0].style.display = 'none';
                }
            }
            
            const maxMenuAAURs = App.GEBC('append-able-user-row', App.GEBI('maxMenu'));
            for (let i = 0; i < maxMenuAAURs.length; i++) {
                var maxMenuAAUR = maxMenuAAURs[i];
                if (maxMenuAAUR.hasAttribute('user-id') && maxMenuAAUR.getAttribute('user-id') === userId) {
                    if (App.GEBC('new-msg-num', maxMenuAAUR)[0]) {
                        App.GEBC('new-msg-num', maxMenuAAUR)[0].style.display = 'none';
                    }
                }
            }

            App.handleChatBoxHeight ();

        } else {
            console.warn('Not set "user id" attribute on the user row');
        }
    }
    
    /**
     This static method handle to display singleChatWindow{i}.
    **/
    static openSingleChatWindow(row) {
        if (row.hasAttribute('user-id')) {
            // get user id from the user row...
            const userId = row.getAttribute('user-id');
            var chatRowType = (row.hasAttribute('chat-row-type'))?(row.getAttribute('chat-row-type')):('genaral-chat-row');

            // To insert user id into the single chat box `HIDEN-DATA-BOX` input to petch data from DB...
            App.GEBI('singleChatUserId').value = userId;
            App.GEBI('singleChatWindow').setAttribute('class', `${chatRowType} single-chat-wrr`);
            App.GEBC('chatBoxRemoveButton', App.GEBI('singleChatWindow'))[0].setAttribute('user-id', userId);
            App.GEBC('appended-chat-box', App.GEBI('singleChatWindow'))[0].style.display = 'flex';
            App.GEBC('pinp-btn', App.GEBI('singleChatWindow'))[0].setAttribute('chat-row-type', chatRowType);
            App.GEBC('pinp-btn', App.GEBI('singleChatWindow'))[0].setAttribute('user-id', userId);

            // To insert emoji pad into the single chat box...
            App.GEBC('msg-input-emogi-box', App.GEBI('singleChatWindow'))[0].innerHTML = App.generateEmojiPad();
            
            // To display single chat window...
            App.GEBI('startUpWindow').style['display'] = 'none';
            App.GEBI('multipleChatWindow').style['display'] = 'none';
            App.GEBI('singleChatWindow').style['display'] = 'block';
        } else {
            console.warn('Not set "user id" attribute on the user row');
        }
    }

    /**
     This static method handle to configure chat box height into the multipleChatWindow{i}.
    **/    
    static handleChatBoxHeight () {
        const container = App.GEBI('multipleChatWindow');
        var divs = container.querySelectorAll('.genaral-chat-row');
    
        if (divs.length <= 3) {
            divs.forEach(div => {
                div.classList.remove('half-height');
                div.classList.add('full-height');
            });
        } else {
            divs.forEach(div => {
                div.classList.remove('full-height');
                div.classList.add('half-height');
            });
        }

        var divs = container.querySelectorAll('.archive-chat-row');
    
        if (divs.length <= 3) {
            divs.forEach(div => {
                div.classList.remove('half-height');
                div.classList.add('full-height');
            });
        } else {
            divs.forEach(div => {
                div.classList.remove('full-height');
                div.classList.add('half-height');
            });
        }
    }

    /**
     This static method handle ChatBoxContainer.
    **/
    static handleChatBoxContainer() {
        const appendableUserRows = App.GEBC('append-able-user-row');
        for (let i = 0; i < appendableUserRows.length; i++) {

            // To handle single click on the user row...
            appendableUserRows[i].onclick = function (event) {
                event.stopPropagation();
                App.openMultipleChatWindow(this,i);
            }

            // To handle double click on the user row...
            appendableUserRows[i].ondblclick = function (event) {
                event.stopPropagation();
                App.openMultipleChatWindow(this,i);
                App.openSingleChatWindow(this);
            }

            const fullScreenBtn = App.GEBC('fullScreenBtn', appendableUserRows[i])[0];
            if (fullScreenBtn) {
                fullScreenBtn.onclick = function (event) {
                    event.stopPropagation();
                    App.openMultipleChatWindow(appendableUserRows[i],i);
                    App.openSingleChatWindow(appendableUserRows[i]);
                }
            }

            const handExpandBtn =  App.GEBC('hand-expand-btn',appendableUserRows[i])[0];
            if (handExpandBtn) {
                handExpandBtn.onclick = function (event) {
                    event.stopPropagation();
                    const msrPacketMsgBox =  App.GEBC('msr-packet-msg-box',appendableUserRows[i].parentNode)[0];
                    const rightCol =  App.GEBC('right-col',appendableUserRows[i])[0];

                    if (msrPacketMsgBox) {
                        if (msrPacketMsgBox.style.display === 'flex') {
                            msrPacketMsgBox.style.display = 'none';
                            handExpandBtn.getElementsByTagName('svg')[0].style.transform = 'rotate(90deg)';
                            rightCol.style.opacity = '';
                            appendableUserRows[i].classList.remove('bg-shed');
                        } else {
                            msrPacketMsgBox.style.display = 'flex';
                            handExpandBtn.getElementsByTagName('svg')[0].style.transform = 'rotate(180deg)';
                            rightCol.style.opacity = '1';
                            appendableUserRows[i].classList.add('bg-shed');
                            msrPacketMsgBox.getElementsByClassName('msg-data-view-box')[0].scrollTop = msrPacketMsgBox.getElementsByClassName('msg-data-view-box')[0].scrollHeight;
                        }
                    }
                }
            }
        }
    }

    /**
     This static method handle to remove chat box when clicked on x-mark buttons.
    **/
    static handleChatBoxRemove() {
        setInterval(() => {

            const mmbes = App.GEBC('multiple-msg-box', App.GEBI('multipleChatWindow'));
            for (let i = 0; i < mmbes.length; i++) {
                const mmb = mmbes[i];
                App.GEBC('chatBoxRemoveButton', mmb)[0].onclick = function (event) {
                    event.stopPropagation();
                    if (this.hasAttribute('del-id') && this.hasAttribute('user-id')) {
                        var delId = this.getAttribute('del-id');
                        var userId = this.getAttribute('user-id');
                        const elementToRemove = App.GEBI(delId);

                        elementToRemove.remove();
                        App.handleChatBoxHeight ();
                        App.state.appendedUserIds.delete(userId);
                
                        if (App.GEBI('archiveTabBtnInpc').checked) {
                            if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                                // To open start-up window...
                                App.GEBI('startUpWindow').style['display'] = 'flex';
                                App.GEBI('multipleChatWindow').style['display'] = 'none';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            } else {
                                // To open multiple chat window...
                                App.GEBI('startUpWindow').style['display'] = 'none';
                                App.GEBI('multipleChatWindow').style['display'] = 'flex';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            }
                        } else {
                            if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                                // To open start-up window...
                                App.GEBI('startUpWindow').style['display'] = 'flex';
                                App.GEBI('multipleChatWindow').style['display'] = 'none';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            } else {
                                // To open multiple chat window...
                                App.GEBI('startUpWindow').style['display'] = 'none';
                                App.GEBI('multipleChatWindow').style['display'] = 'flex';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            }
                        }
                    }
                }
            }

            const singleChatWindow = App.GEBI('singleChatWindow');
            App.GEBC('chatBoxRemoveButton', singleChatWindow)[0].onclick = function () {
                if (this.hasAttribute('user-id')) {

                    var userId = this.getAttribute('user-id');
                    var delId = App.state.MFUR.get(userId);
                    const elementToRemove = App.GEBI(delId);

                    App.state.appendedUserIds.delete(userId);
                    App.state.MFUR.delete(userId);
                    elementToRemove.remove();

                    if (App.GEBI('archiveTabBtnInpc').checked) {
                        if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        } else {
                            // To open multiple chat window...
                            App.GEBI('startUpWindow').style['display'] = 'none';
                            App.GEBI('multipleChatWindow').style['display'] = 'flex';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }
                    } else {
                        if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        } else {
                            // To open multiple chat window...
                            App.GEBI('startUpWindow').style['display'] = 'none';
                            App.GEBI('multipleChatWindow').style['display'] = 'flex';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }
                    }
                }
            }
        }, 100);
    }

    /**
     * cbcmr = chat box current margin right.
     * This static method handle pinp chat box margine right.
     */
    static handleCbcmr() {
        var pinpMsgBoxes = App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow'));
        for (let i = 0; i < pinpMsgBoxes.length; i++) {
            var cbcmr = (i) * 350 + 20 * (i+1);
            const pinpMsgBox = pinpMsgBoxes[i];
            pinpMsgBox.style['right'] = `${cbcmr}px`;
        }

        var pinpMsgBoxes = App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow'));
        for (let i = 0; i < pinpMsgBoxes.length; i++) {
            var cbcmr = (i) * 350 + 20 * (i+1);
            const pinpMsgBox = pinpMsgBoxes[i];
            pinpMsgBox.style['right'] = `${cbcmr}px`;
        }
    }

    /**
     This static method handle pinp-chat-box`s all actions.
    **/
    static handlePinpChatBox () {
        setInterval(() => {
            const mmbes = App.GEBC('multiple-msg-box', App.GEBI('multipleChatWindow'));
            for (let i = 0; i < mmbes.length; i++) { 
                const mmb = mmbes[i];
                App.GEBC('pinp-btn', mmb)[0].onclick = function () {
                    App.GEBI('pinpChatWindow').style['display'] = 'flex';
                    if (this.hasAttribute('user-id')) {

                        var chatRowType = (this.hasAttribute('chat-row-type'))?(this.getAttribute('chat-row-type')):('genaral-chat-row');
                        var userId = this.getAttribute('user-id');
                        var delId = App.state.MFUR.get(userId);
                        const elementToRemove = App.GEBI(delId);
                        elementToRemove.remove();

                        // To apend a new chat box on multiple chat window...
                        const RID = delId;
                        const chatBox =  App.CE('div');
                        var en = (App.GEBI('archiveTabBtnInpc').checked) ? (App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow')).length + 1) : App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow')).length + 1;
                        var cbcmr = (en-1) * 350 + 20 * en;

                        chatBox.setAttribute('class', `${chatRowType} msg-index-box pinp-msg-box appended-chat-box`);
                        chatBox.setAttribute('id', RID);
                        chatBox.setAttribute('style', `right:${cbcmr}px;`);
                        chatBox.innerHTML = `
                        <div class="HIDEN-DATA-BOX" style="display: none;">
                                <input type="hidden" name="multipleChatUserId${RID}" class="userIdContainerInputBox" id="multipleChatUserId${RID}" value=${userId}>
                            </div>
                        <div class="msg-index-head p-1rem">
                            <div class="flex jcsb aic g-0_5rem">
                                <div class="left-col flex g-0_5rem aic">
                                    <div class="user-img-box append-box-img flex jcc aic">
                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                        <div class="online-indicator"></div>
                                    </div>
                                    <div class="user-name-and-last-msg-container">
                                        <div class="user-name-box">Mahadi Hasan</div>
                                        <div class="msg-sent-time-stamp">4 hours ago</div>
                                    </div>
                                </div>
                                <div class="flex aic g-0_5rem">
                                    <div class="call-btn flex jcc aic cup" user-id="${userId}">${App.icons.phone}</div>
                                    <div class="flex cup fullScreenBtn" chat-row-type="${chatRowType}" del-id="${RID}" user-id="${userId}">${App.icons.fullScreen}</div>
                                    <div class="btot-btn flex jcc aic cup" chat-row-type="${chatRowType}" user-id="${userId}">${App.icons.btot}</div>
                                    <div class="remove-btn chatBoxRemoveButton flex jcc aic cup" del-id="${RID}" user-id="${userId}">${App.icons.xmark}</div>
                                    <div class="arrow-btn OpenCloseBtn flex jcc aic cup" style="transform: rotate(180deg);">${App.icons.arrow}</div>
                                </div>
                            </div>
                        </div>
                        <div class="msg-index-body OpenCloseBody">
                            <div class="ofh flex ffc wh-100">
                    
                                <div class="msg-view-boxes-wrr-row ofh">
                                    <div class="msg-data-view-box p-1rem wh-100">

                                        <div class="flex ffc g-1rem">
                                            <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            Hi! Seth, How are you?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span> 5 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            I'm fine Josef. And you?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            I'm also fine! Seth, Where are you now? If you are at home now, then i say could you please go with me in my university?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>5 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            Yes Josef I'm at home. And I'm ready to go with you. So when you will go?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="msg-call-view-box"></div>
                                    <div class="msg-audio-view-box"></div>
                                    <div class="msg-file-view-box"></div>
                                </div>
                    
                                <form action="#" method="post" enctype="multipart/form-data" autocomplete="off" aria-required="true">
                                    <div class="msg-input-box-wrr flex g-0_5rem p-1rem">
                                        <div class="msg-input-attace-file-box sml-box-grp flex jcc aic">
                                            ${App.icons.attachFile}
                                            <input type="file" name="attace-file" class="fileUploadBtn" id="__file__${RID}" parent-id="${RID}" multiple>
                                        </div>
                                        <div class="msg-input-text-box flex jcc aic">
                                            <input type="text" name="msg-input" class="chat-box-text-input-container" parent-id="${RID}" placeholder="Type to massage">
                                        </div>
                                        <!--<div class="msg-input-voice-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.audio}</div>-->
                                        <div class="msg-input-emoji-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.generateEmojiPad()}</div>
                                        <div class="msg-input-love-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.love}</div>
                                        <div class="msg-input-send-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.send}</div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        `;
                        App.GEBI('pinpChatWindow').append(chatBox);
                    
                        // To scroll the new chat box on the bottom...
                        const RIDE = App.GEBI(RID);
                        const msgDataViewBox = App.GEBC('msg-data-view-box',RIDE)[0];
                        msgDataViewBox.scrollTop = msgDataViewBox.scrollHeight;

    
                        if (App.GEBI('archiveTabBtnInpc').checked) {
                            if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                                // To open start-up window...
                                App.GEBI('startUpWindow').style['display'] = 'flex';
                                App.GEBI('multipleChatWindow').style['display'] = 'none';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            } else {
                                // To open multiple chat window...
                                App.GEBI('startUpWindow').style['display'] = 'none';
                                App.GEBI('multipleChatWindow').style['display'] = 'flex';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            }
                        } else {
                            if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                                // To open start-up window...
                                App.GEBI('startUpWindow').style['display'] = 'flex';
                                App.GEBI('multipleChatWindow').style['display'] = 'none';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            } else {
                                // To open multiple chat window...
                                App.GEBI('startUpWindow').style['display'] = 'none';
                                App.GEBI('multipleChatWindow').style['display'] = 'flex';
                                App.GEBI('singleChatWindow').style['display'] = 'none';
                            }
                        }

                        App.handleChatBoxHeight();
                    }
                }
            }

            App.GEBC('pinp-btn', App.GEBI('singleChatWindow'))[0].onclick = function (event) {
                event.stopPropagation();
                console.log('hello');
                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                if (this.hasAttribute('user-id')) {

                    var chatRowType = (this.hasAttribute('chat-row-type'))?(this.getAttribute('chat-row-type')):('genaral-chat-row');
                    var userId = this.getAttribute('user-id');
                    var delId = App.state.MFUR.get(userId);
                    const elementToRemove = App.GEBI(delId);
                    elementToRemove.remove();

                    // To apend a new chat box on multiple chat window...
                    const RID = delId;
                    const chatBox =  App.CE('div');
                    var en = (App.GEBI('archiveTabBtnInpc').checked) ? (App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow')).length + 1) : App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow')).length + 1;
                    var cbcmr = (en-1) * 350 + 20 * en;

                    chatBox.setAttribute('class', `${chatRowType} msg-index-box pinp-msg-box appended-chat-box`);
                    chatBox.setAttribute('id', RID);
                    chatBox.setAttribute('style', `right:${cbcmr}px;`);
                    chatBox.innerHTML = `
                    <div class="HIDEN-DATA-BOX" style="display: none;">
                            <input type="hidden" name="multipleChatUserId${RID}" class="userIdContainerInputBox" id="multipleChatUserId${RID}" value=${userId}>
                        </div>
                    <div class="msg-index-head p-1rem">
                        <div class="flex jcsb aic g-0_5rem">
                            <div class="left-col flex g-0_5rem aic">
                                <div class="user-img-box append-box-img flex jcc aic">
                                    <img src="./img/camera-4921646_1280.jpg" alt="">
                                    <div class="online-indicator"></div>
                                </div>
                                <div class="user-name-and-last-msg-container">
                                    <div class="user-name-box">Mahadi Hasan</div>
                                    <div class="msg-sent-time-stamp">4 hours ago</div>
                                </div>
                            </div>
                            <div class="flex aic g-0_5rem">
                                <div class="call-btn flex jcc aic cup" user-id="${userId}">${App.icons.phone}</div>
                                <div class="flex cup fullScreenBtn" chat-row-type="${chatRowType}" del-id="${RID}" user-id="${userId}">${App.icons.fullScreen}</div>
                                <div class="btot-btn flex jcc aic cup" chat-row-type="${chatRowType}" user-id="${userId}">${App.icons.btot}</div>
                                <div class="remove-btn chatBoxRemoveButton flex jcc aic cup" del-id="${RID}" user-id="${userId}">${App.icons.xmark}</div>
                                <div class="arrow-btn OpenCloseBtn flex jcc aic cup" style="transform: rotate(180deg);">${App.icons.arrow}</div>
                            </div>
                        </div>
                    </div>
                    <div class="msg-index-body OpenCloseBody">
                        <div class="ofh flex ffc wh-100">
                
                            <div class="msg-view-boxes-wrr-row ofh">
                                <div class="msg-data-view-box p-1rem wh-100">

                                    <div class="flex ffc g-1rem">
                                        <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                            <div class="flex ffc g-0_5rem w-100">
                                                <div class="img-text-wrapper">
                                                    <span class="user-img-wrapper">
                                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                                        <span class="online-indicator"></span>
                                                    </span>
                                                    <span class="msg-data-wrapper">
                                                        Hi! Seth, How are you?
                                                    </span>
                                                </div>
                                                <div class="msg-sent-time-stamp"><span class="dot"></span> 5 hours ago</div>
                                            </div>
                                        </div>

                                        <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                            <div class="flex ffc g-0_5rem w-100">
                                                <div class="img-text-wrapper">
                                                    <span class="user-img-wrapper">
                                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                                        <span class="online-indicator"></span>
                                                    </span>
                                                    <span class="msg-data-wrapper">
                                                        I'm fine Josef. And you?
                                                    </span>
                                                </div>
                                                <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                            </div>
                                        </div>

                                        <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                            <div class="flex ffc g-0_5rem w-100">
                                                <div class="img-text-wrapper">
                                                    <span class="user-img-wrapper">
                                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                                        <span class="online-indicator"></span>
                                                    </span>
                                                    <span class="msg-data-wrapper">
                                                        I'm also fine! Seth, Where are you now? If you are at home now, then i say could you please go with me in my university?
                                                    </span>
                                                </div>
                                                <div class="msg-sent-time-stamp"><span class="dot"></span>5 hours ago</div>
                                            </div>
                                        </div>

                                        <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                            <div class="flex ffc g-0_5rem w-100">
                                                <div class="img-text-wrapper">
                                                    <span class="user-img-wrapper">
                                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                                        <span class="online-indicator"></span>
                                                    </span>
                                                    <span class="msg-data-wrapper">
                                                        Yes Josef I'm at home. And I'm ready to go with you. So when you will go?
                                                    </span>
                                                </div>
                                                <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="msg-call-view-box"></div>
                                <div class="msg-audio-view-box"></div>
                                <div class="msg-file-view-box"></div>
                            </div>
                
                            <form action="#" method="post" enctype="multipart/form-data" autocomplete="off" aria-required="true">
                                <div class="msg-input-box-wrr flex g-0_5rem p-1rem">
                                    <div class="msg-input-attace-file-box sml-box-grp flex jcc aic">
                                        ${App.icons.attachFile}
                                        <input type="file" name="attace-file" class="fileUploadBtn" id="__file__${RID}" parent-id="${RID}" multiple>
                                    </div>
                                    <div class="msg-input-text-box flex jcc aic">
                                        <input type="text" name="msg-input" class="chat-box-text-input-container" parent-id="${RID}" placeholder="Type to massage">
                                    </div>
                                    <!--<div class="msg-input-voice-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.audio}</div>-->
                                    <div class="msg-input-emoji-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.generateEmojiPad()}</div>
                                    <div class="msg-input-love-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.love}</div>
                                    <div class="msg-input-send-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.send}</div>
                                </div>
                            </form>
                        </div>
                    </div>
                    `;
                    App.GEBI('pinpChatWindow').append(chatBox);
                
                    // To scroll the new chat box on the bottom...
                    const RIDE = App.GEBI(RID);
                    const msgDataViewBox = App.GEBC('msg-data-view-box',RIDE)[0];
                    msgDataViewBox.scrollTop = msgDataViewBox.scrollHeight;


                    if (App.GEBI('archiveTabBtnInpc').checked) {
                        if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        } else {
                            // To open multiple chat window...
                            App.GEBI('startUpWindow').style['display'] = 'none';
                            App.GEBI('multipleChatWindow').style['display'] = 'flex';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }
                    } else {
                        if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        } else {
                            // To open multiple chat window...
                            App.GEBI('startUpWindow').style['display'] = 'none';
                            App.GEBI('multipleChatWindow').style['display'] = 'flex';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }
                    }

                    App.handleChatBoxHeight();
                }
            }

            const pinpMsgBoxes = App.GEBC('pinp-msg-box', App.GEBI('pinpChatWindow'));
            for (let i = 0; i < pinpMsgBoxes.length; i++) {
                const pinpMsgBox = pinpMsgBoxes[i];
                App.GEBC('OpenCloseBtn', pinpMsgBox)[0].onclick = function (event) {
                    event.stopPropagation();
                    if (pinpMsgBox.style['min-height'] === '65px') {
                        pinpMsgBox.style['min-height'] = '400px';
                        this.style['transform'] = 'rotate(180deg)';
                        
                    } else {
                        pinpMsgBox.style['min-height'] = '65px';
                        this.style['transform'] = 'rotate(0deg)';
                    }
                }

                App.GEBC('chatBoxRemoveButton', pinpMsgBox)[0].onclick = function (event) {
                    event.stopPropagation();
                    if (this.hasAttribute('del-id') && this.hasAttribute('user-id')) {
                        var delId = this.getAttribute('del-id');
                        var userId = this.getAttribute('user-id');
                        const elementToRemove = App.GEBI(delId);

                        elementToRemove.remove();
                        App.state.appendedUserIds.delete(userId);
                        


                        if (App.GEBC('appended-chat-box',App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }

                        if (App.GEBI('archiveTabBtnInpc').checked) {
                            if (App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                                App.GEBI('pinpChatWindow').style['display'] = 'none';
                            } else {
                                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                            }
                        } else {
                            if (App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                                App.GEBI('pinpChatWindow').style['display'] = 'none';
                            } else {
                                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                            }
                        }

                        App.handleCbcmr();
                    }
                }

                App.GEBC('fullScreenBtn', pinpMsgBox)[0].onclick = function (event) {
                    event.stopPropagation();
                    if (this.hasAttribute('user-id')) {

                        var chatRowType = (this.hasAttribute('chat-row-type'))?(this.getAttribute('chat-row-type')):('genaral-chat-row');
                        var userId = this.getAttribute('user-id');
                        var delId = App.state.MFUR.get(userId);
                        const elementToRemove = App.GEBI(delId);
                        elementToRemove.remove();

                        // To apend a new chat box on multiple chat window...
                        const RID = delId;
                        const chatBox =  App.CE('div');
                        chatBox.setAttribute('class', `${chatRowType} msg-index-box multiple-msg-box appended-chat-box`);
                        chatBox.setAttribute('id', RID);
                        chatBox.innerHTML = `
                        <div class="HIDEN-DATA-BOX" style="display: none;">
                                <input type="hidden" name="multipleChatUserId${RID}" class="userIdContainerInputBox" id="multipleChatUserId${RID}" value=${userId}>
                            </div>
                        <div class="msg-index-head p-1rem">
                            <div class="flex jcsb aic g-0_5rem">
                                <div class="left-col flex g-0_5rem aic">
                                    <div class="user-img-box append-box-img flex jcc aic">
                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                        <div class="online-indicator"></div>
                                    </div>
                                    <div class="user-name-and-last-msg-container">
                                        <div class="user-name-box">Mahadi Hasan</div>
                                        <div class="msg-sent-time-stamp">4 hours ago</div>
                                    </div>
                                </div>
                                <div class="flex aic g-0_5rem">
                                    <div class="call-btn flex jcc aic cup" user-id="${userId}">${App.icons.phone}</div>
                                    <div class="flex cup fullScreenBtn" chat-row-type="${chatRowType}" del-id="${RID}" user-id="${userId}">${App.icons.fullScreen}</div>
                                    <div class="pinp-btn flex jcc aic cup" chat-row-type="${chatRowType}" user-id="${userId}">${App.icons.pinp}</div>
                                    <div class="remove-btn chatBoxRemoveButton flex jcc aic cup" del-id="${RID}" user-id="${userId}" user-row-index="${i}">${App.icons.xmark}</div>
                                    <!--<div class="arrow-btn OpenCloseBtn flex jcc aic cup" style="transform: rotate(180deg);">${App.icons.arrow}</div>-->
                                </div>
                            </div>
                        </div>
                        <div class="msg-index-body OpenCloseBody">
                            <div class="ofh flex ffc wh-100">
                    
                                <div class="msg-view-boxes-wrr-row ofh">
                                    <div class="msg-data-view-box p-1rem wh-100">
                                        <div class="flex ffc g-1rem">
                                            <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            Hi! Seth, How are you?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span> 5 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            I'm fine Josef. And you?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            I'm also fine! Seth, Where are you now? If you are at home now, then i say could you please go with me in my university?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>5 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            Yes Josef I'm at home. And I'm ready to go with you. So when you will go?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="msg-call-view-box"></div>
                                    <div class="msg-audio-view-box"></div>
                                    <div class="msg-file-view-box"></div>
                                </div>
                    
                                <form action="#" method="post" enctype="multipart/form-data" autocomplete="off" aria-required="true">
                                    <div class="msg-input-box-wrr flex g-0_5rem p-1rem">
                                        <div class="msg-input-attace-file-box sml-box-grp flex jcc aic">
                                            ${App.icons.attachFile}
                                            <input type="file" name="attace-file" class="fileUploadBtn" id="__file__${RID}" parent-id="${RID}" multiple>
                                        </div>
                                        <div class="msg-input-text-box flex jcc aic">
                                            <input type="text" name="msg-input" class="chat-box-text-input-container" parent-id="${RID}" placeholder="Type to massage">
                                        </div>
                                        <!--<div class="msg-input-voice-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.audio}</div>-->
                                        <div class="msg-input-emoji-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.generateEmojiPad()}</div>
                                        <div class="msg-input-love-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.love}</div>
                                        <div class="msg-input-send-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.send}</div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        `;
                        App.GEBI('multipleChatWindow').prepend(chatBox);

                        App.handleChatBoxHeight();
                        App.handleCbcmr();

                        // To scroll the new chat box on the bottom...
                        const RIDE = App.GEBI(RID);
                        const msgDataViewBox = App.GEBC('msg-data-view-box',RIDE)[0];
                        msgDataViewBox.scrollTop = msgDataViewBox.scrollHeight;

                        // To open multiple chat window...
                        App.GEBI('startUpWindow').style['display'] = 'none';
                        App.GEBI('multipleChatWindow').style['display'] = 'flex';
                        App.GEBI('singleChatWindow').style['display'] = 'none';

                        if (App.GEBI('archiveTabBtnInpc').checked) {
                            if (App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                                App.GEBI('pinpChatWindow').style['display'] = 'none';
                            } else {
                                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                            }
                        } else {
                            if (App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                                App.GEBI('pinpChatWindow').style['display'] = 'none';
                            } else {
                                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                            }
                        }
                    }
                    App.openSingleChatWindow(this);
                }

                App.GEBC('btot-btn', pinpMsgBox)[0].onclick = function (event) {
                    event.stopPropagation();
                    if (this.hasAttribute('user-id')) {

                        var chatRowType = (this.hasAttribute('chat-row-type'))?(this.getAttribute('chat-row-type')):('genaral-chat-row');
                        var userId = this.getAttribute('user-id');
                        var delId = App.state.MFUR.get(userId);
                        const elementToRemove = App.GEBI(delId);
                        elementToRemove.remove();

                        // To apend a new chat box on multiple chat window...
                        const RID = delId;
                        const chatBox =  App.CE('div');
                        chatBox.setAttribute('class', `${chatRowType} msg-index-box multiple-msg-box appended-chat-box`);
                        chatBox.setAttribute('id', RID);
                        chatBox.innerHTML = `
                        <div class="HIDEN-DATA-BOX" style="display: none;">
                                <input type="hidden" name="multipleChatUserId${RID}" class="userIdContainerInputBox" id="multipleChatUserId${RID}" value=${userId}>
                            </div>
                        <div class="msg-index-head p-1rem">
                            <div class="flex jcsb aic g-0_5rem">
                                <div class="left-col flex g-0_5rem aic">
                                    <div class="user-img-box append-box-img flex jcc aic">
                                        <img src="./img/camera-4921646_1280.jpg" alt="">
                                        <div class="online-indicator"></div>
                                    </div>
                                    <div class="user-name-and-last-msg-container">
                                        <div class="user-name-box">Mahadi Hasan</div>
                                        <div class="msg-sent-time-stamp">4 hours ago</div>
                                    </div>
                                </div>
                                <div class="flex aic g-0_5rem">
                                    <div class="call-btn flex jcc aic cup" user-id="${userId}">${App.icons.phone}</div>
                                    <div class="flex cup fullScreenBtn" chat-row-type="${chatRowType}" del-id="${RID}" user-id="${userId}">${App.icons.fullScreen}</div>
                                    <div class="pinp-btn flex jcc aic cup" chat-row-type="${chatRowType}" user-id="${userId}">${App.icons.pinp}</div>
                                    <div class="remove-btn chatBoxRemoveButton flex jcc aic cup" del-id="${RID}" user-id="${userId}" user-row-index="${i}">${App.icons.xmark}</div>
                                    <!--<div class="arrow-btn OpenCloseBtn flex jcc aic cup" style="transform: rotate(180deg);">${App.icons.arrow}</div>-->
                                </div>
                            </div>
                        </div>
                        <div class="msg-index-body OpenCloseBody">
                            <div class="ofh flex ffc wh-100">
                    
                                <div class="msg-view-boxes-wrr-row ofh">
                                    <div class="msg-data-view-box p-1rem wh-100">
                                        <div class="flex ffc g-1rem">
                                            <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            Hi! Seth, How are you?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span> 5 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            I'm fine Josef. And you?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="outgoing-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            I'm also fine! Seth, Where are you now? If you are at home now, then i say could you please go with me in my university?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>5 hours ago</div>
                                                </div>
                                            </div>

                                            <div class="incoming-row w-100 msg-data-view-box flex aifs g-1rem">
                                                <div class="flex ffc g-0_5rem w-100">
                                                    <div class="img-text-wrapper">
                                                        <span class="user-img-wrapper">
                                                            <img src="./img/camera-4921646_1280.jpg" alt="">
                                                            <span class="online-indicator"></span>
                                                        </span>
                                                        <span class="msg-data-wrapper">
                                                            Yes Josef I'm at home. And I'm ready to go with you. So when you will go?
                                                        </span>
                                                    </div>
                                                    <div class="msg-sent-time-stamp"><span class="dot"></span>4 hours ago</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="msg-call-view-box"></div>
                                    <div class="msg-audio-view-box"></div>
                                    <div class="msg-file-view-box"></div>
                                </div>
                    
                                <form action="#" method="post" enctype="multipart/form-data" autocomplete="off" aria-required="true">
                                    <div class="msg-input-box-wrr flex g-0_5rem p-1rem">
                                        <div class="msg-input-attace-file-box sml-box-grp flex jcc aic">
                                            ${App.icons.attachFile}
                                            <input type="file" name="attace-file" class="fileUploadBtn" id="__file__${RID}" parent-id="${RID}" multiple>
                                        </div>
                                        <div class="msg-input-text-box flex jcc aic">
                                            <input type="text" name="msg-input" class="chat-box-text-input-container" parent-id="${RID}" placeholder="Type to massage">
                                        </div>
                                        <!--<div class="msg-input-voice-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.audio}</div>-->
                                        <div class="msg-input-emoji-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.generateEmojiPad()}</div>
                                        <div class="msg-input-love-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.love}</div>
                                        <div class="msg-input-send-box sml-box-grp flex jcc aic" parent-id="${RID}">${App.icons.send}</div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        `;
                        App.GEBI('multipleChatWindow').prepend(chatBox);

                        App.handleChatBoxHeight();
                        App.handleCbcmr();

                        // To scroll the new chat box on the bottom...
                        const RIDE = App.GEBI(RID);
                        const msgDataViewBox = App.GEBC('msg-data-view-box',RIDE)[0];
                        msgDataViewBox.scrollTop = msgDataViewBox.scrollHeight;

                        // To open multiple chat window...
                        App.GEBI('startUpWindow').style['display'] = 'none';
                        App.GEBI('multipleChatWindow').style['display'] = 'flex';
                        App.GEBI('singleChatWindow').style['display'] = 'none';

                        if (App.GEBI('archiveTabBtnInpc').checked) {
                            if (App.GEBC('archive-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                                App.GEBI('pinpChatWindow').style['display'] = 'none';
                            } else {
                                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                            }
                        } else {
                            if (App.GEBC('genaral-chat-row', App.GEBI('pinpChatWindow')).length <= 0) {
                                App.GEBI('pinpChatWindow').style['display'] = 'none';
                            } else {
                                App.GEBI('pinpChatWindow').style['display'] = 'flex';
                            }
                        }
                    }
                }
            }
        }, 100);
    }

    /**
     This static method handle chat box minimization...
    **/
    static handleChatBoxMinimization() {
        setInterval(() => {
            const minimizeBtn = App.GEBC('minimize-btn');
            for (let i = 0; i < minimizeBtn.length; i++) {
                minimizeBtn[i].onclick = function (event) {
                    event.stopPropagation();
                    
                    if (App.GEBI('archiveTabBtnInpc').checked) {
                        if (App.GEBC('archive-chat-row',App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        } else {
                            // To open multiple chat window...
                            App.GEBI('startUpWindow').style['display'] = 'none';
                            App.GEBI('multipleChatWindow').style['display'] = 'flex';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }
                    } else {
                        if (App.GEBC('genaral-chat-row', App.GEBI('multipleChatWindow')).length <= 0) {
                            // To open start-up window...
                            App.GEBI('startUpWindow').style['display'] = 'flex';
                            App.GEBI('multipleChatWindow').style['display'] = 'none';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        } else {
                            // To open multiple chat window...
                            App.GEBI('startUpWindow').style['display'] = 'none';
                            App.GEBI('multipleChatWindow').style['display'] = 'flex';
                            App.GEBI('singleChatWindow').style['display'] = 'none';
                        }
                    }
                }
            }
        }, 100);
    }

    /**
     This static method handle chat box maximization...
    **/
    static handleChatBoxMaximization() {
        setInterval(() => {
            const maximizeBtns = App.GEBC('fullScreenBtn', App.GEBI('multipleChatWindow'))
            for (let i = 0; i < maximizeBtns.length; i++) {
                maximizeBtns[i].onclick = function (event) {
                    event.stopPropagation();
                    App.openSingleChatWindow(this);
                }
            }
        }, 100);
    }

    /**
     This static method is for generate chat box EmojiPad.
    **/
    static generateEmojiPad() {
        const emojiArray = App.emojis;
        var emojiData = `<div class="popupPack">
        <div class="popupBtnPad">
        <div class="popupBtn cup"><div class="gol">${App.icons.emoji}</div></div>
        </div>
        <div class="popupMenuPad emogi-popupMenuPad">
        <div class="popupArrow emogi-popupArrow"></div>
        <div class="pop_up_menu_wraffer emogi-pop_up_menu_wraffer">
        <div class="flex jcc ffw aic g-0_5rem">`;

        for (let i = 0; i < emojiArray.length; i++) {
            emojiData += `<div class="emoji-ib">${emojiArray[i]}</div>`;
        }

        emojiData += `</div></div></div></div>`;

        return emojiData;
    }

    /**
     This static method handle emoji to insert into the input box.
    **/
    static hanleEmojiToInsert() {
        setInterval(() => {
            const msgIndexBoxes = App.GEBC('msg-index-box');
            for (let i = 0; i < msgIndexBoxes.length; i++) {
                const msgIndexBox = msgIndexBoxes[i];
                const emojiIbs = App.GEBC('emoji-ib', msgIndexBox);
                for (let j = 0; j < emojiIbs.length; j++) {
                    const emojiIb = emojiIbs[j];
                    emojiIb.onclick = function (event) {
                        event.stopPropagation();
                        App.GEBC('chat-box-text-input-container', msgIndexBox)[0].value += this.innerHTML;
                    }
                }

                App.GEBC('msg-input-love-box', msgIndexBox)[0].onclick = function (event) {
                    event.stopPropagation();
                    App.GEBC('chat-box-text-input-container', msgIndexBox)[0].value += '💖';
                }
            }
        }, 100);
    }

    /**
     This static method hanle call window.
    **/
    static hanleCallWindow() {
        setInterval(() => {
            const msgIndexBoxes = App.GEBC('msg-index-box');
            for (let i = 0; i < msgIndexBoxes.length; i++) {
                const msgIndexBox = msgIndexBoxes[i];
                const callBtn = App.GEBC('call-btn', msgIndexBox)[0];
                callBtn.onclick = function (event) {
                    event.stopPropagation();
                    const userId = this.getAttribute('user-id');
                    const url = 'callWindow.html?userId=' + userId;

                    const windowName = 'uniqueWindow';
                    const width = 400;
                    const height = 500;

                    // Calculate the center position
                    const left = (screen.width / 2) - (width / 2);
                    const top = (screen.height / 2) - (height / 2);

                    const windowFeatures = `width=${width},height=${height},left=${left},top=${top}`;

                    // Check if the window is already open
                    if (!App.state.isOpenedCallWindow || App.state.isOpenedCallWindow.closed) {
                         App.state.isOpenedCallWindow = window.open(url, windowName, windowFeatures);
                    } else {
                         // Replace the URL of the existing window
                         App.state.isOpenedCallWindow.location.href = url;
                         App.state.isOpenedCallWindow.focus();
                    }
                }
            }

            const msgIndexBodyRows = App.GEBC('append-able-user-row');
            for (let i = 0; i < msgIndexBodyRows.length; i++) {
                const msgIndexBodyRow = msgIndexBodyRows[i];
                const callBtn = App.GEBC('user-call-btn', msgIndexBodyRow)[0];
                if (callBtn) {
                    callBtn.onclick = function (event) {
                        event.stopPropagation();
                        const userId = msgIndexBodyRow.getAttribute('user-id');
                        const url = 'callWindow.html?userId=' + userId;

                        const windowName = 'uniqueWindow';
                        const width = 400;
                        const height = 500;

                        // Calculate the center position
                        const left = (screen.width / 2) - (width / 2);
                        const top = (screen.height / 2) - (height / 2);

                        const windowFeatures = `width=${width},height=${height},left=${left},top=${top}`;

                        // Check if the window is already open
                        if (!App.state.isOpenedCallWindow || App.state.isOpenedCallWindow.closed) {
                            App.state.isOpenedCallWindow = window.open(url, windowName, windowFeatures);
                        } else {
                            // Replace the URL of the existing window
                            App.state.isOpenedCallWindow.location.href = url;
                            App.state.isOpenedCallWindow.focus();
                        }
                    }
                }
            }
        }, 100);
    }

    /**
     This static method handle addNewContactPad{i}`s display system.
    **/
    static handleAddNewContact() {
        App.GEBI('addNewContactOpenBtn').onclick = function () {
            App.GEBI('addNewContactPad').style.display = 'flex';
        }

        App.GEBI('addNewContactPadQuitBtn').onclick = function () {
            App.GEBI('addNewContactPad').style.display = 'none';
        }
    }

    // call all the static methods.
    static start() {
        App.handleSideMenu();
        App.handleOCT();
        App.handleTab();
        App.handlePopUp();
        App.handleSearchBytext();

        App.handleChatBoxContainer();
        App.handleChatBoxRemove();
        App.handleChatBoxMinimization();
        App.handleChatBoxMaximization();

        App.handlePinpChatBox();

        App.handleAddNewContact();
        App.hanleEmojiToInsert();
        App.hanleCallWindow()
    }
}

App.start();